<?php 
$title = "Dashboard";
$slug = "dashboard";

include 'inc.header.php'; ?>
<style>
.card-header {
font-size:24px;
font-weight:bold;
}
</style>
<h1 class="text-center"><?php echo $_SESSION['companyName']; ?></h1>
<!-- Dashboard Content -->
<div class="container mt-5">
    <div class="row">
        <div class="col-md-12">
          <h1 class="text-center"><?=$_SESSION['company_name']?></h1>
            <p class="text-center">This is your ISO Pro Dashboard where you can manage your audits and track reports.</p>
        </div>
    </div>
<!-- Dashboard Sections -->
<div class="row mt-4">

<!-- Profile Section -->
<div class="col-md-4 mb-4">
  <div class="card text-center">
    <div class="card-header">
      Step 1
      <i class="bi bi-info-circle ms-2 text-primary" data-bs-toggle="modal" data-bs-target="#infoStep1"></i>
    </div>
    <div class="card-body">
      <p class="card-text">Let's Get Started.</p>
      <a href="profile.php" class="btn btn-primary btn-lg">Program Management <i class="bi bi-arrow-bar-right"></i> <i class="bi bi-person-lines-fill"></i></a>
    </div>
  </div>
</div>

<!-- Audit Planner Section -->
<div class="col-md-4 mb-4">
  <div class="card text-center">
    <div class="card-header">
      Step 2
      <i class="bi bi-info-circle ms-2 text-primary" data-bs-toggle="modal" data-bs-target="#infoStep2"></i>
    </div>
    <div class="card-body">
      <p class="card-text">Setup Your Audit.</p>
      <a href="audit-planning.php" class="btn btn-success btn-lg">Audit Planner <i class="bi bi-arrow-bar-right"></i> <i class="bi bi-bricks"></i></a>
    </div>
  </div>
</div>

<!-- Audit Report Summary Section -->
<div class="col-md-4 mb-4">
  <div class="card text-center">
    <div class="card-header">
      Step 3
      <i class="bi bi-info-circle ms-2 text-primary" data-bs-toggle="modal" data-bs-target="#infoStep3"></i>
    </div>
    <div class="card-body">
      <p class="card-text">Start the Audit.</p>
      <a href="settings.php" class="btn btn-danger btn-lg">Audit Report Summary <i class="bi bi-arrow-bar-right"></i> <i class="bi bi-card-checklist"></i></a>
    </div>
  </div>
</div>

<!-- Auditor Competencies Section -->
<div class="col-md-4 mb-4">
  <div class="card text-center">
    <div class="card-header">
      Going away
      <i class="bi bi-info-circle ms-2 text-primary" data-bs-toggle="modal" data-bs-target="#infoStep4"></i>
    </div>
    <div class="card-body">
      <p class="card-text">Enter Your Auditors.</p>
      <a href="manage_auditors.php" class="btn btn-warning btn-lg">Auditor Competencies <i class="bi bi-arrow-bar-right"></i> <i class="bi bi-file-earmark-person"></i></a>
    </div>
  </div>
</div>

<!-- ISO Guidelines Section -->
<div class="col-md-4 mb-4">
  <div class="card text-center">
    <div class="card-header">
      ISO
      <i class="bi bi-info-circle ms-2 text-primary" data-bs-toggle="modal" data-bs-target="#infoStep5"></i>
    </div>
    <div class="card-body">
      <p class="card-text">Review the Guidelines.</p>
      <a href="iso_guidelines.php" class="btn btn-info btn-lg">ISO Guidance <i class="bi bi-arrow-bar-right"></i> <i class="bi bi-bookmark-star-fill"></i></a>
    </div>
  </div>
</div>

<!-- Findings Section -->
<div class="col-md-4 mb-4">
  <div class="card text-center">
    <div class="card-header">
      Findings
      <i class="bi bi-info-circle ms-2 text-primary" data-bs-toggle="modal" data-bs-target="#infoStep6"></i>
    </div>
    <div class="card-body">
      <p class="card-text">Review Findings.</p>
      <a href="#" class="btn btn-secondary btn-lg">Findings <i class="bi bi-arrow-bar-right"></i> <i class="bi bi-bezier2"></i></a>
    </div>
  </div>
</div>

<!-- Findings Section -->
<div class="col-md-4 mb-4">
  
</div>



<!-- Modals -->
<div>
  <!-- Info Modal for Step 1 -->
  <div class="modal fade" id="infoStep1" tabindex="-1" aria-labelledby="infoStep1Label" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="infoStep1Label">Step 1 - Program Management</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Provide details about your company and auditors to get started.
<!-- Placeholder Video -->
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/oFr0x2HqAYk?si=leHwvBIRwV6lmYBG" 
                  title="Placeholder Video" 
                  allowfullscreen></iframe>
        </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Info Modal for Step 2 -->
  <div class="modal fade" id="infoStep2" tabindex="-1" aria-labelledby="infoStep2Label" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="infoStep2Label">Step 2 - Audit Planner</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Plan and schedule your audit activities efficiently.
<!-- Placeholder Video -->
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/oFr0x2HqAYk?si=leHwvBIRwV6lmYBG" 
                  title="Placeholder Video" 
                  allowfullscreen></iframe>
        </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Info Modal for Step 3 -->
  <div class="modal fade" id="infoStep3" tabindex="-1" aria-labelledby="infoStep3Label" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="infoStep3Label">Step 3 - Audit Report Summary</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Review the outcomes of your audits and track both strengths and weaknesses.
<!-- Placeholder Video -->
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/oFr0x2HqAYk?si=leHwvBIRwV6lmYBG" 
                  title="Placeholder Video" 
                  allowfullscreen></iframe>
        </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Info Modal for Step 4 -->
  <div class="modal fade" id="infoStep4" tabindex="-1" aria-labelledby="infoStep4Label" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="infoStep4Label">Step 4 - Auditor Competencies</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Enter details about your auditors and their qualifications.
<!-- Placeholder Video -->
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/oFr0x2HqAYk?si=leHwvBIRwV6lmYBG" 
                  title="Placeholder Video" 
                  allowfullscreen></iframe>
        </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Info Modal for Step 5 -->
  <div class="modal fade" id="infoStep5" tabindex="-1" aria-labelledby="infoStep5Label" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="infoStep5Label">Step 5 - ISO Guidance</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Review and familiarize yourself with the ISO guidelines.
<!-- Placeholder Video -->
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/oFr0x2HqAYk?si=leHwvBIRwV6lmYBG" 
                  title="Placeholder Video" 
                  allowfullscreen></iframe>
        </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>

  <!-- Info Modal for Step 6 -->
  <div class="modal fade" id="infoStep6" tabindex="-1" aria-labelledby="infoStep6Label" aria-hidden="true">
    <div class="modal-dialog">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title" id="infoStep6Label">Step 6 - Findings</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          Review and address findings from the audit process.
<!-- Placeholder Video -->
        <div class="ratio ratio-16x9">
          <iframe src="https://www.youtube.com/embed/oFr0x2HqAYk?si=leHwvBIRwV6lmYBG" 
                  title="Placeholder Video" 
                  allowfullscreen></iframe>
        </div>
        </div>
        <div class="modal-footer">
          <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Close</button>
        </div>
      </div>
    </div>
  </div>
</div>

</div>

</div>



<?php
// Database connection
$servername = "localhost";
$username = "iso";
$password = "2VFz1jilzOWXMupl";
$dbname = "iso";

$conn = new mysqli($servername, $username, $password, $dbname);

if ($conn->connect_error) {
    die("Connection failed: " . $conn->connect_error);
}

// Fetch records for the current company_id
$company_id = $_SESSION['user_id']; // Replace with the dynamic company ID if needed
$sql = "SELECT id, company_name, auditor_id, site_type, audit_type, standards, created_at 
        FROM audit_profile_info 
        WHERE company_id = ? 
        ORDER BY created_at DESC";
$stmt = $conn->prepare($sql);
$stmt->bind_param("s", $company_id);
$stmt->execute();
$result = $stmt->get_result();

// Check if there are records
if ($result->num_rows > 0) {
    echo '<div class="container mt-5">';
    echo '<h2 class="text-center">My Audits</h2>';
    echo '<table class="table table-hover table-striped table-bordered mt-3">';
    echo '<thead>';
    echo '<tr>';
    echo '<th>Score</th>';
    echo '<th>Company Name</th>';
    echo '<th>Auditor ID</th>';
    echo '<th>Site Type</th>';
    echo '<th>Audit Type</th>';
    echo '<th>Standards</th>';
    echo '<th>Created At</th>';
    echo '<th>Action</th>';
    echo '</tr>';
    echo '</thead>';
    echo '<tbody>';
    while ($row = $result->fetch_assoc()) {
        echo '<tr>';
        $percent = rand(60, 100); // Generate a random number between 0 and 100
        echo '<td>' . $percent . '%</td>';
        echo '<td>' . htmlspecialchars($row['company_name']) . '</td>';
        echo '<td>' . htmlspecialchars($row['auditor_id']) . '</td>';
        echo '<td>' . htmlspecialchars($row['site_type']) . '</td>';
        echo '<td>' . htmlspecialchars($row['audit_type']) . '</td>';
        echo '<td>' . htmlspecialchars($row['standards']) . '</td>';
        echo '<td>' . htmlspecialchars($row['created_at']) . '</td>';
        echo '<td><a href="audit-planning.php?id=' . htmlspecialchars($row['id']) . '" class="btn btn-outline-success">View Audit Summary</a> <a href="#" class="btn btn-outline-info">Grant Admin Access</a></td>';
        echo '</tr>';
    }
    echo '</tbody>';
    echo '</table>';
    echo '</div>';
} else {
    echo '<div class="container mt-5">';
    echo '<p class="text-center">No audit records found for this company.</p>';
    echo '</div>';
}

$stmt->close();
$conn->close();
?>

<?php include 'inc.footer.php'; ?>
